///////////////////////////////////////////////////////////////////////////////
// Copyright (C) 1999-2005 Siebel Systems, Inc.  All rights reserved.
///////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////

function ColumnFormulaEditor(editorID, bIsListFormat, filterExprElement)
{
   this.eid = editorID;
   this.form = document.forms[editorID + 'Form'];
   this.errorCell = document.getElementById(editorID + "Error");
   
   this.myId = editorID;

   this.propertyPages = new XUIPropertyPagesControl(editorID + 'Props');

   if (null != bIsListFormat && bIsListFormat == true)
   {
      this.bIsListFormat = true;
      this.webExpressionSelector = new WebExpressionSelector('idWebExprSelector');
   }

   this.clipboard = null;

   this.htmlTable = document.getElementById('idColumnFormulaBinTable');
   this.links = document.getElementById('idColumnFormulaBinLinks');

   // append the workspace XML node for the mini-report XML nodes (for Binning)
   {
      var tIslandNQW = XUIGetRootXML();
      this.tBinWorkSpace = tIslandNQW.selectSingleNode("saw:binWorkSpace");
      if (null == this.tBinWorkSpace)
         this.tBinWorkSpace = XUIAppendNewElement(tIslandNQW, saw.xml.kSawNamespace, "binWorkSpace");
   }

   this.binScrollDiv = document.getElementById(editorID + "ColumnFormulaBinsScrollDiv");
   this.binNote = document.getElementById(editorID + "ColumnFormulaBinNote");

   this.binsTreatAsExprCell = document.getElementById(editorID + "BinsTreatAsExprCell");
   this.binsTreatAsExprCheck = document.getElementsByName("treatBinsAsExpr")[0];

   // update the filter table id(s) to accommodate filter definitions for Binning
   {
      // mark the edit filter table
      var tFilterTableEdit = document.getElementById ("idFilterTableEdit");
      if (null != tFilterTableEdit)
         tFilterTableEdit.bForEdit = true;

      this.resetFilterTableIds();
   }

   this.filterExprElement = filterExprElement;
   
   this.hideHeadings = false;
}

ColumnFormulaEditor.prototype = new XUIEditor();

//-------------------
ColumnFormulaEditor.prototype.load = function(xmlElement, criteriaElement)
{
   this.element = xmlElement;
   this.criteriaElement = criteriaElement;
   this.originalElement = this.element.cloneNode(true);
   this.originalCriteria = this.criteriaElement.cloneNode(true);

   this.savedCaretPos = null;

   XUICheckNodeName("ColumnFormulaEditor.prototype.load", xmlElement, "saw:column");
   XUICheckNodeName("ColumnFormulaEditor.prototype.load", criteriaElement, "saw:criteria");

   // if derived criteria, turn off the Bins tab
   var bDerived = XUIGetXsiType(criteriaElement) == "derived";
   var tBinsTabCell = document.getElementById(this.myId + 'Propstab2');
   if (null != tBinsTabCell)
      tBinsTabCell.style.display = bDerived ? "none" : "";

   // back up the original bins
   this.originalBins = null;
   var tBins = this.element.selectSingleNode("saw:bins");
   if (null != tBins)
      this.originalBins = tBins.cloneNode(true);

   this.showBinNote(false);

   // used for validation (creates a new report with just the necessary criteria)
   var tReport = XUICreateElement(saw.xml.kSawNamespace, 'report');
   tReport.setAttribute('xmlns:xsi', 'http://www.w3.org/2001/XMLSchema-instance');
   tReport.setAttribute('xmlns:sawx','com.siebel.analytics.web/expression/v1');

   tReport.appendChild(criteriaElement.cloneNode(true));

   this.form.ReportXML.value = saw.getXmlText(tReport);
   this.form.ColumnID.value = XUIGetAttributeString(this.element, "columnID");

   var tErrorCellChild = document.getElementById(this.errorCell.id + 'Child');
   if (tErrorCellChild != null)
      this.errorCell.removeChild(tErrorCellChild);

   this.form.formula.value = XUIGetAttributeString(this.element, "formula");

   if (null == this.filterExprElement && (null == this.hideHeadings || this.hideHeadings == false))
   {
      this.form.tableHdg.style.display = '';
      this.form.columnHdg.style.display = '';
      document.getElementById("FormulaTableHdgID").style.display = '';
      document.getElementById("FormulaColumnHdgID").style.display = '';
      document.getElementById("FormulaCustomHdgID").style.display = '';

      // need to set this first so headings can be defaulted
      var bCustom = bDerived ? true : XUIColumn.hasCustomHeadings(this.element);

      this.form.customHdg.checked = bCustom;
      this.form.customHdg.disabled = bDerived;

      if (bCustom)
      {
         this.form.tableHdg.value = XUICaptionSpace.getCaptionText(this.element.selectSingleNode("saw:tableHeading"));
         this.form.columnHdg.value = XUICaptionSpace.getCaptionText(this.element.selectSingleNode("saw:columnHeading"));

         document.getElementById("FormulaTableHdgID").className = "XUIPromptCaption";
         document.getElementById("FormulaColumnHdgID").className = "XUIPromptCaption";
         this.form.tableHdg.disabled = false;
         this.form.columnHdg.disabled = false;
      }
      else
      {
         this.displayDefaultHeadings();

         document.getElementById("FormulaTableHdgID").className = "XUIPromptDisabledCaption";
         document.getElementById("FormulaColumnHdgID").className = "XUIPromptDisabledCaption";
         this.form.tableHdg.disabled = true;
         this.form.columnHdg.disabled = true;
      }
   }
   else
   {
      this.form.tableHdg.style.display = 'none';
      this.form.columnHdg.style.display = 'none';
      document.getElementById("FormulaTableHdgID").style.display = 'none';
      document.getElementById("FormulaColumnHdgID").style.display = 'none';
      document.getElementById("FormulaCustomHdgID").style.display = 'none';
   }
   XUISelectOptionFromAttribute(this.form.aggRule, this.element, "aggRule")

   //CellFormatEditor.applyDisplayFormat(this.form.tableHdg, this.element.selectSingleNode("saw:tableHeading"));
   //CellFormatEditor.applyDisplayFormat(this.form.columnHdg, this.element.selectSingleNode("saw:columnHeading"));

   this.clipboard = null;

   // update the filter table id(s) to accommodate filter definitions for Binning
   this.resetFilterTableIds();

   // display bins (without having to retrieve the case statement from the server)
   this.displayBins(false);
   
   if (this.bIsListFormat)
   {
      this.aliasTD = document.getElementById("aliasTD");
      var tListOptions = this.criteriaElement.selectSingleNode("//saw:listOptions");
      if (XUIGetAttributeString(tListOptions, "formatOutputType", "") == "database") 
      {
         this.form.AliasInput.className = "XUIPromptCaption";
         this.form.AliasInput.disabled = false;
      }
      else 
      {
         this.aliasTD.className = "XUIPromptDisabledCaption";
         this.form.AliasInput.disabled = true;
         XUISetOrRemoveAttributeString(this.element, "alias");
      }
      this.form.AliasInput.value = XUIGetAttributeString(this.element, "alias", '');
   }
   
}

//-------------------
ColumnFormulaEditor.prototype.apply = function()
{
   if (this.bInServerRequest)
      return false;

   // reset any remaining idFilterTable to the original id
   {
      this.resetFilterTableIds();

      // reset the criteria pane filter table id
      var tCurrentTable = document.getElementById ("idFilterTableCriteriaPane");
      if (null != tCurrentTable)
         tCurrentTable.id = "idFilterTable";
   }

   // check if saw:bins has any children; if not, clean it up
   {
      var tCurrentBins = this.element.selectSingleNode("saw:bins");
      if (null != tCurrentBins && null == tCurrentBins.selectSingleNode("saw:bin"))
         this.element.removeChild(tCurrentBins);
   }

   while ((this.form.formula.value.length > 0) && (this.form.formula.value.indexOf(' ') == 0))
      this.form.formula.value = this.form.formula.value.substr(1, this.form.formula.value.length);

   while ((this.form.formula.value.length > 0) && (this.form.formula.value.lastIndexOf(' ') == this.form.formula.value.length-1))
      this.form.formula.value = this.form.formula.value.substr(0, this.form.formula.value.length-1);

   if (this.bIsListFormat)
   {
      if (!this.form.AliasInput.disabled)
         XUISetOrRemoveAttributeString(this.element, 'alias', this.form.AliasInput.value); 
   }

   if (this.form.formula.value != "")
   {
      // does the formula contain web expressions?
      if (XUIColumn.hasWebVariableExpressions(this.form.formula.value))
      {
         // enable custom headings if they are not already
         if (!this.form.customHdg.checked)
         {
            this.form.customHdg.checked = true;
            ColumnFormulaEditor.onClickCustom(this.myId);
         }
      }

      // used for validation (creates a new report with just the necessary criteria)
      var tReport = XUICreateElement(saw.xml.kSawNamespace, 'report');
      tReport.setAttribute('xmlns:xsi', 'http://www.w3.org/2001/XMLSchema-instance');
      tReport.setAttribute('xmlns:sawx','com.siebel.analytics.web/expression/v1');

      tReport.appendChild(this.criteriaElement.cloneNode(true));

      this.form.ReportXML.value = saw.getXmlText(tReport);

      var req = new sawr.serverRequest("GetColumnInfoXML", ColumnFormulaEditor.loadColumnInfo);
 	   req.setFatalErrorHandler(ColumnFormulaEditor.handleServerError);
      req.setCallerObj(this);
      
      var conn = new sawr.xhrConnection(req);

      conn.postForm(this.form);
      
      this.bInServerRequest = true;

      return false;
   }
   
   return true;
}

//-------------------
ColumnFormulaEditor.loadColumnInfo = function(tData)
{
   var tEditor = tData.getCallerObj();
   tEditor.bInServerRequest = false;
   
   var tErrorCellChild = document.getElementById(tEditor.errorCell.id + 'Child');
   if (tErrorCellChild != null)
      tEditor.errorCell.removeChild(tErrorCellChild);

   // update the column space
   var tColumnSpace = tData.getXML().selectSingleNode(".//saw:columnSpace");

   //columnformula editor is used in context of a FILTER
   if (null == tEditor.filterExprElement)
   {
      var tColumnInfoNodes = tColumnSpace.selectNodes("saw:columnInfo");
      for (var i=0; i < tColumnInfoNodes.length; i++)
      {
         tColumnInfoNode = tColumnInfoNodes[i];

         var sColumnID = XUIGetAttributeString(tColumnInfoNode, "columnID", "");
         if (sColumnID != "")
            XUIColumnSpace.replaceColumnInfo(tColumnInfoNode);
         else
         {
            // if columnExpr's present, that represents the 'raw' formula (before variables are evaluated)
            var sColumnExpr = XUIGetAttributeString(tColumnInfoNode, "columnExpr");
            var tCurrent = XUIColumnSpace.findInfo(null, 
                              XUIColumn.hasWebVariableExpressions(sColumnExpr) ? sColumnExpr : 
                                 XUIGetAttributeString(tColumnInfoNode, "formula", "missing"));
            if (null != tCurrent)
               XUIColumnSpace.xmlElement.replaceChild(tColumnInfoNode, tCurrent);
            else
               XUIColumnSpace.xmlElement.appendChild(tColumnInfoNode);
         }
      }
   }
   else
   {
      //add the column space
      var tResultColInfo = tData.getXML().selectSingleNode(".//saw:columnInfo");
      //XUISetOrRemoveAttributeString (tResultColInfo, "columnID", null);
      XUIColumnSpace.xmlElement.appendChild(tResultColInfo.cloneNode(true));
   }
   
   var aContext = tData.getContextInfo();
   if (aContext)
      tEditor.update(aContext[0]);
   else
      tEditor.update(null);
}

ColumnFormulaEditor.handleServerError = function(tData, aFatal)
{   
   var tEditor = tData.getCallerObj();
   tEditor.bInServerRequest = false;

   var tErrorCellChild = document.getElementById(tEditor.errorCell.id + 'Child');
   if (tErrorCellChild != null)
      tEditor.errorCell.removeChild(tErrorCellChild);

   if (tEditor && aFatal && aFatal.length)  
   {
      var sErrorText = "";

      for (var i=0; i<aFatal.length; i++)
      {
         // Write out the error, but skip the intro exception and the SQL Issued: exception
         var sMsg = aFatal[i].getMessage();
         if ((sMsg.indexOf("SQLExecDirectW") == -1) &&
             (sMsg.indexOf("NQSGetQueryColumnInfo") == -1))
         {
            var nNQS = sMsg.indexOf("[nQSError");
            if (nNQS >= 0)
               sErrorText += saw.encodeHTML(sMsg.substring(nNQS, sMsg.length));
            else
               sErrorText += saw.encodeHTML(sMsg);
               
            sErrorText += "<br>";
         }
      }      
      var tSpan = document.createElement("div");
      tSpan.id = tEditor.errorCell.id + 'Child';
      tSpan.className = 'ColumnFormulaError';
      tSpan.innerHTML = sErrorText + " " + kuiColumnFormulaEditorForceOK;
      tEditor.errorCell.appendChild(tSpan);

      if (tData.getContextInfo())
         tEditor.errorCell.sCallerContext = tData.getContextInfo()[0];
      XUIPropertyPagesControl.onActivateTab (tEditor.myId + 'Props', 'tab1');
   }

   var sScript = tData.getScript();
   if (sScript && sScript == "UpdateColumnSpaceDiscard")
   {
      tEditor.discard(null, true); // discard and close the dialog
      return;
   }
}

//-------------------
ColumnFormulaEditor.prototype.discard = function(event, bClose)
{
   if (this.bInServerRequest)
      return false;
   
   if (null != this.functionSelector
      || null != this.complexFilterEditor
      || null != this.variableSelector)
   {
      this.functionSelector = null;
      this.complexFilterEditor = null;
      this.variableSelector = null;
      return;
   }

   if (null != this.columnFormulaBinFilterEditor)
   {
      // clean up the bin if it does not have a filter expr
      // this would be the case ONLY when the bin was being newly created
      {
         var tBin = this.getBinFromIndex(this.columnFormulaBinFilterEditor.reportIndex);
         if (null != tBin && null == tBin.selectSingleNode("sawx:expr"))
         {
            var tBins = tBin.parentNode;
            tBins.removeChild(tBin);

            // if the only bin remaining is the All Other Values one, clean that up too
            if (tBins.childNodes.length == 1)
            {
               var tLastBin = tBins.childNodes[0];

               // is the last bin the "All Other Values" one?
               if (null != tLastBin &&
                   XUIGetAttributeBool(tLastBin, "allOther"))
                  tBins.removeChild(tLastBin);
            }

            // if there is no remaining bin, remove the bins element
            if (null == tBins.firstChild)
               tBins.parentNode.removeChild(tBins);
         }
      }

      this.columnFormulaBinFilterEditor = null;
      // display bins (without having to retrieve the case statement from the server)
      this.displayBins(false);
      return; // the ColumnFormulaEditor dialog is not going away!
   }

   if (null != this.restoreFormulaConfirmDlg)
   {
      if (null == this.bDiscardCancel || this.bDiscardCancel == false)
      {
         // do the actual delete if from delete all
         if (this.restoreFormulaConfirmDlg.bFromDeleteAll)
            this.doDeleteAllBins();

         // restore the original formula of this column
         this.form.formula.value = this.restoreFormulaConfirmDlg.sOriginalFormula;

         this.restoreFormulaConfirmDlg = null;

         // go to the first tab
         XUIPropertyPagesControl.onActivateTab (this.myId + 'Props', 'tab1');

         // make the server call to update the column space
         {
            // used for validation (creates a new report with just the necessary criteria)
            var tReport = XUICreateElement(saw.xml.kSawNamespace, 'report');
            tReport.setAttribute('xmlns:xsi', 'http://www.w3.org/2001/XMLSchema-instance');
            tReport.setAttribute('xmlns:sawx','com.siebel.analytics.web/expression/v1');

            tReport.appendChild(this.criteriaElement.cloneNode(true));

            this.form.ReportXML.value = saw.getXmlText(tReport);

            var req = new sawr.serverRequest("GetColumnInfoXML", ColumnFormulaEditor.loadColumnInfo);
 	         req.setFatalErrorHandler(ColumnFormulaEditor.handleServerError);
            req.setCallerObj(this);
            req.setContextInfo([ "GetBinFormula" ]);
            
            var conn = new sawr.xhrConnection(req);
            conn.postForm(this.form);            
         }
      }
      else
         this.bDiscardCancel = null;

      this.restoreFormulaConfirmDlg = null;
      return;
   }

   if (null != this.columnFormulaBinCaptionEditor)
   {
      // redraw the bins (and fetch formula as necessary)
      this.displayBins(this.columnFormulaBinCaptionEditor.bNewCaption);
      this.columnFormulaBinCaptionEditor = null;
      return;
   }

   if (bClose)
   {
      // reset any remaining idFilterTable to the original id
      {
         this.resetFilterTableIds();

         // reset the criteria pane filter table id
         var tCurrentTable = document.getElementById ("idFilterTableCriteriaPane");
         if (null != tCurrentTable)
            tCurrentTable.id = "idFilterTable";
      }

      // restore the original bins if any
      {
         var tCurrentBins = this.element.selectSingleNode("saw:bins");
         if (null != tCurrentBins)
            this.element.removeChild(tCurrentBins);

         if (null != this.originalBins)
            this.element.appendChild(this.originalBins);
      }

      // check if saw:bins has any children; if not, clean it up
      {
         var tCurrentBins = this.element.selectSingleNode("saw:bins");
         if (null != tCurrentBins && null == tCurrentBins.selectSingleNode("saw:bin"))
            this.element.removeChild(tCurrentBins);
      }

      this.showBinNote(false);

      this.parentEditor.discard();
      this.panel.close();
   }
   else
   {
      // setup the original formula prior to bin changes
      this.form.formula.value = XUIGetAttributeString(this.originalElement, "formula");

      while ((this.form.formula.value.length > 0) && (this.form.formula.value.indexOf(' ') == 0))
         this.form.formula.value = this.form.formula.value.substr(1, this.form.formula.value.length);

      while ((this.form.formula.value.length > 0) && (this.form.formula.value.lastIndexOf(' ') == this.form.formula.value.length-1))
         this.form.formula.value = this.form.formula.value.substr(0, this.form.formula.value.length-1);

      if (this.form.formula.value != "")
      {
         // restore the original column space entries by way of the server call
         var tReport = XUICreateElement(saw.xml.kSawNamespace, 'report');
         tReport.setAttribute('xmlns:xsi', 'http://www.w3.org/2001/XMLSchema-instance');
         tReport.setAttribute('xmlns:sawx','com.siebel.analytics.web/expression/v1');

         tReport.appendChild(this.originalCriteria.cloneNode(true));

         this.form.ReportXML.value = saw.getXmlText(tReport);

      // make a server call to get the CASE statement
      var req = new sawr.serverRequest("GetColumnInfoXML", ColumnFormulaEditor.updateColumnSpaceDiscard);
 	   req.setFatalErrorHandler(ColumnFormulaEditor.handleServerError);
      req.setCallerObj(this);
      req.setContextInfo(["UpdateColumnSpaceDiscard"]);
      var conn = new sawr.xhrConnection(req);
      conn.postForm(this.form);

      this.bInServerRequest = true;
      
      return false;
   }
      else
      {
         this.discard(null, true); // discard and close the dialog
         return false;
      }
   }
}

//-------------------
ColumnFormulaEditor.updateColumnSpaceDiscard = function(tData)
{
   ColumnFormulaEditor.loadColumnInfo(tData);
   tData.getCallerObj().discard(null, true); // discard and close the dialog
}

//-------------------
ColumnFormulaEditor.prototype.update = function(sCallerContext)
{   
   // null is standard ignore, so validate
   // validated means they want to ignore the validation
   if ((sCallerContext == null) || (sCallerContext == "validated"))
   {
      // Cayman query blocking: call validation function before continuing
      if (sCallerContext == null)
      {
         var vac = validateAnalysisFormula(this.form.formula.value, this.form.aggRule.value);
         if (vac != true)
         {
            if (vac != false)
            {
               var tErrorCellChild = document.getElementById(this.errorCell.id + 'Child');
               if (tErrorCellChild != null)
                  this.errorCell.removeChild(tErrorCellChild);

               var tSpan = document.createElement("div");
               tSpan.className = 'ColumnFormulaError';
               tSpan.id = tEditor.errorCell.id + 'Child';
               tSpan.innerHTML = vac + "  " + kuiColumnFormulaEditorForceOK;
               this.errorCell.appendChild(tSpan);

               this.errorCell.sCallerContext = "validated";
               XUIPropertyPagesControl.onActivateTab (this.myId + 'Props', 'tab1');
            }
            return;
         }
      }

      if (this.form.customHdg.checked)  // add the headings
      {
         var tTblHdg = new XUICaptionParent(XUIForceSingleNode(this.element, saw.xml.kSawNamespace, 'tableHeading'));
         var tColHdg = new XUICaptionParent(XUIForceSingleNode(this.element, saw.xml.kSawNamespace, 'columnHeading'));

         tTblHdg.setCaptionText(this.form.tableHdg.value);
         tColHdg.setCaptionText(this.form.columnHdg.value);
      }
      else
      {
         // remove the two child elements if they have no non-caption children (e.g. displayFormat) of their own
         var tTableHeading = this.element.selectSingleNode("saw:tableHeading");
         if (null != tTableHeading)
         {
            var tTblHdgCaption = tTableHeading.selectSingleNode("saw:caption");
            if (null != tTblHdgCaption)
               tTableHeading.removeChild(tTblHdgCaption);

            if (null == saw.getFirstChildElement(tTableHeading))
               this.element.removeChild(tTableHeading);
         }

         var tColumnHeading = this.element.selectSingleNode("saw:columnHeading");
         if (null != tColumnHeading)
         {
            var tColHdgCaption = tColumnHeading.selectSingleNode("saw:caption");
            if (null != tColHdgCaption)
               tColumnHeading.removeChild(tColHdgCaption);

            if (null == saw.getFirstChildElement(tColumnHeading))
               this.element.removeChild(tColumnHeading);
         }
      }

      this.element.setAttribute("formula", this.form.formula.value);

      XUISetAttributeFromSelectedOption(this.form.aggRule, this.element, "aggRule")

      this.showBinNote(false);

      // close dialog and propogate
      this.panel.apply(true);
      this.panel.close();
   }

}

//-------------------
ColumnFormulaEditor.prototype.focus = function()
{
   if (this.propertyPages.getLastTab() != 'tab2')
   {
      var tTextArea = this.form.formula;

      if (is_ie)
      {
         tTextArea.focus();
         var tSel = document.selection.createRange();
         tSel.moveToElementText(tTextArea);
         tSel.select();
      }
      else
      {
         tTextArea.focus();
         tTextArea.setSelectionRange(0, tTextArea.value.length);
      }
      ColumnFormulaEditor.storeCaret(tTextArea);
   }
}

//-------------------
// Use the columnspace if the formula matches, otherwise create from column formula
ColumnFormulaEditor.prototype.displayDefaultHeadings = function()
{
   var tTblHdg = new XUICaptionParent(this.element.selectSingleNode("saw:tableHeading"));
   var tColHdg = new XUICaptionParent(this.element.selectSingleNode("saw:columnHeading"));

   var tInfo = XUIColumnSpace.findInfo(this.element.getAttribute("columnID"), this.form.formula.value);
   if (tInfo == null)
   {
      this.form.tableHdg.value = XUIColumn.getTableHeadingFromFormula(this.form.formula.value);
      this.form.columnHdg.value = XUIColumn.getColumnHeadingFromFormula(this.form.formula.value);
   }
   else
   {
      this.form.tableHdg.value = XUIColumnSpace.getInfoHeading(tInfo, "saw:tableHeading");
      this.form.columnHdg.value = XUIColumnSpace.getInfoHeading(tInfo, "saw:columnHeading");
   }
}

//-------------------
ColumnFormulaEditor.prototype.insertText = function(sText, bSubstituteExpr)
{
   var tTextArea = this.form.formula;

   // if the text area is read-only (when there are bins defined), do not do anything
   if (tTextArea.readOnly)
      return;

   var sSep = " ";
   var sToReplace = null;      

   if (bSubstituteExpr != null && bSubstituteExpr == true)
   {
      if (sText.indexOf("expr1") != -1)
         sToReplace = /expr1/
      else if (sText.indexOf("expr") != -1)
         sToReplace = /expr/;
   }

   if (is_ie)
   {
      var tTR = document.body.createTextRange();
      tTR.moveToElementText(tTextArea);
      var   tSel = document.selection.createRange();
      var sTR=tTextArea.value;
      if (tTR.inRange(tSel))       //if focused
      {
         //if no text selected && does not have an operand at the end or the text is not just spaces && cursor is at the end of the text
         var tRE = new RegExp("(^\\s*$)|([\\-*/(+,]\\s*$)", "g");
         if ((tSel.text == '') &&  (!(tRE.test(tTextArea.value))) && (tTR.compareEndPoints('EndToEnd', tSel) == 0))
         {
            tSel.text = sSep + sText;
         }
         else
         {
            if (sToReplace != null)
            {
               var sSelectedText = tSel.text;
               sText = sText.replace(sToReplace, sSelectedText);
            }	
            tSel.text = sText + sSep;
         }
         tSel.select();
      }
      else                       //if blurred
      {
         tTextArea.focus();                               //put focus on the textarea
         if (tTextArea.createTextRange && this.savedCaretPos)
         {
            var startIndex = -1;
            var endIndex = -1;

            var caretPos = this.savedCaretPos;
            if (sToReplace != null)
            {
               var sSelectedText = caretPos.text;
               if (sSelectedText.length > 0)
               {
                  sText = sText.replace(sToReplace, sSelectedText);
               }
               else
               {
                  var start1 = sText.indexOf("expr1");

                  if (start1 != -1)
                  {
                     startIndex = sText.length - start1;
                     endIndex = startIndex - 5;
                  }
                  else
                  {
                     start1 = sText.indexOf("expr");
                     if (start1 != -1)
                     {
                        startIndex = sText.length - start1;
                        endIndex = startIndex - 4;
                     }
                  }
               }
            }	
            caretPos.text = caretPos.text.charAt(caretPos.text.length - 1) == ' ' ? sText + ' ' : sText;

            if (startIndex != -1)
            {
               caretPos.moveStart("character", (startIndex * -1));
               caretPos.moveEnd("character", (endIndex * -1));
            }
            caretPos.select();
         }
         else
         {
            tTextArea.value += sText;

            tTR.moveToElementText(tTextArea);

            tTR.collapse(false);
            tTR.select();
         }
      }
   }
   else
   {
      var tTR = document.createRange();
      tTR.selectNodeContents(tTextArea);

      var sTR=tTextArea.value;

      if (tTextArea.selectionStart != -1 && tTextArea.selectionEnd != -1)       //if focused
      {
         var start = tTextArea.selectionStart;
         var end = tTextArea.selectionEnd;

         var sStartText = tTextArea.value.substr(0, start);
         var sEndText = tTextArea.value.substr(end, tTextArea.value.length - end);

         if (sToReplace == null)
         {
            tTextArea.value = sStartText + sText + sEndText;
            tTextArea.setSelectionRange(start + sText.length, start + sText.length);
         }
         else
         {
            if ((start != end) && (sToReplace != null))
            {
               var sSelectedText = tTextArea.value.substr(start, end - start);
               sText = sText.replace(sToReplace, sSelectedText);
            }	
            tTextArea.value = sStartText + sText + sEndText;

            if (start != end || (sToReplace == null))   
            {      
               tTextArea.setSelectionRange(start + sText.length, start + sText.length);
            }
            else
            {
               var start1 = sText.indexOf("expr1");

               if (start1 != -1)
               {
                  tTextArea.setSelectionRange(start + start1, start + start1 + 5);
               }
               else
               {
                  start1 = sText.indexOf("expr");
                  if (start1 != -1)
                     tTextArea.setSelectionRange(start + start1, start + start1 + 4);
               }
            }
         }
      }
      else                       //if blurred
      {
         tTextArea.focus();                               //put focus on the textarea
         if (tTextArea.createTextRange && this.savedCaretPos)
         {
            var caretPos = this.savedCaretPos;

            var sSelectedText = caretPos.text;
            if (sSelectedText.length > 0)
            {
               sText = sText.replace(sToReplace, sSelectedText);
            }
            caretPos.text = caretPos.text.charAt(caretPos.text.length - 1) == ' ' ? sText + ' ' : sText;
         }
         else if (sToReplace != null)
            tTextArea.value = sText.replace(sToReplace, tTextArea.value);
         else
            tTextArea.value += sText;

         tTR.selectNodeContents(tTextArea);
         tTR.detach();
      }
      tTextArea.focus();
   }   
   ColumnFormulaEditor.storeCaret(tTextArea);
}

//-------------------
ColumnFormulaEditor.prototype.moveUp = function(nIndex)
{
   var tBin = this.getBinFromIndex(nIndex);
   if (null != tBin && tBin.previousSibling != null)
   {
      tBin.parentNode.insertBefore(tBin, tBin.previousSibling)

      this.displayBins();
   }
}

//-------------------
ColumnFormulaEditor.prototype.moveDown = function(nIndex)
{
   var tBin = this.getBinFromIndex(nIndex);
   if (null != tBin && tBin.nextSibling != null)
   {
      tBin.parentNode.insertBefore(tBin.nextSibling, tBin)

      this.displayBins();
   }
}

//-------------------
ColumnFormulaEditor.prototype.queryRestoreOriginalFormula = function(event, sOriginalFormula, bFromDeleteAll)
{
   if (sOriginalFormula == '')
      return;

   if (null == bFromDeleteAll)
      bFromDeleteAll = false;

   this.restoreFormulaConfirmDlg = new ColumnFormulaBinRestoreEditor('idRestoreFormulaConfirmDlg', this.myId);
   this.restoreFormulaConfirmDlg.sOriginalFormula = sOriginalFormula;
   this.restoreFormulaConfirmDlg.bFromDeleteAll = bFromDeleteAll;

   var tDialog = new XUIDialog('idRestoreFormulaConfirmDlg', this.restoreFormulaConfirmDlg, this);
   tDialog.show(this.element, bFromDeleteAll ? event.clientX : 20, bFromDeleteAll ? event.clientY : 20);
}

//-------------------
ColumnFormulaEditor.prototype.hasBins = function()
{
   var bHasBins = false;
   var tBins = this.element.selectSingleNode("saw:bins");
   if (null != tBins)
   {
      if (null != tBins.firstChild)
         bHasBins = true;
   }

   return bHasBins;
}

//-------------------
ColumnFormulaEditor.prototype.deleteAllBins = function(event)
{
   var sOriginalFormula = '';
   var tBins = this.element.selectSingleNode("saw:bins");
   if (null != tBins)
   {
      // back up the original formula
      if (null != tBins.firstChild)
         sOriginalFormula = XUIGetAttributeString(tBins.firstChild, "formula");
   }

   // show the dialog to ask the user if s/he would want to restore the original formula
   // or preserve the case statement or cancel the delete all operation
   if (sOriginalFormula != '')
      this.queryRestoreOriginalFormula(event, sOriginalFormula, true);
}

//-------------------
ColumnFormulaEditor.prototype.doDeleteAllBins = function()
{
   var tBins = this.element.selectSingleNode("saw:bins");
   if (null != tBins)
      this.element.removeChild(tBins);

   this.displayBins(false);
}

//-------------------
ColumnFormulaEditor.prototype.deleteBin = function(event, nIndex)
{
   var sOriginalFormula = '';
   var bBinsLeft = true;
   var tBin = this.getBinFromIndex(nIndex);
   if (null != tBin)
   {
      // back up the original formula
      sOriginalFormula = XUIGetAttributeString(tBin, "formula");

      var tBins = tBin.parentNode;
      tBins.removeChild(tBin);

      // if the only bin remaining is the All Other Values one, clean that up too
      if (tBins.childNodes.length == 1)
      {
         var tLastBin = tBins.childNodes[0];

         // is the last bin the "All Other Values" one?
         if (null != tLastBin &&
             XUIGetAttributeBool(tLastBin, "allOther"))
            tBins.removeChild(tLastBin);
      }

      // if there is no remaining bin, remove the bins element
      if (null == tBins.firstChild)
      {
         tBins.parentNode.removeChild(tBins);
         bBinsLeft = false;
      }
   }

   this.displayBins();

   // show the dialog to ask the user if s/he would want to restore the original formula
   if (!bBinsLeft && sOriginalFormula != '')
      this.queryRestoreOriginalFormula(event, sOriginalFormula);
}

//-------------------
ColumnFormulaEditor.prototype.copyBin = function(tBin)
{
   this.clipboard = tBin.cloneNode(true);
}

//-------------------
ColumnFormulaEditor.prototype.pasteBin = function(tBin)
{
   if (this.clipboard != null)
   {
      if (tBin.nextSibling != null)
         tBin.parentNode.insertBefore(this.clipboard, tBin.nextSibling);
      else
         tBin.parentNode.appendChild(this.clipboard);

      // make another copy for pasting
      this.clipboard = this.clipboard.cloneNode(true);

      this.displayBins();
   }
}

//-------------------
ColumnFormulaEditor.prototype.showBinNote = function(bShow)
{
   if (null != this.binNote)
   {
      if (bShow)
      {
         this.binNote.innerHTML = '<span class="ColumnFormulaBinNote">' + kmsgColumnFormulaBinsNote + '</span>';
         document.getElementById(this.eid + "InsertButtons").style.display = 'none';
      }
      else
      {
         this.binNote.innerHTML = '<span class="ColumnFormulaBinNote">' + kmsgFormulaEditorInsertDirections + '</span>';
         document.getElementById(this.eid + "InsertButtons").style.display = '';
      }
   }
}

//-------------------
ColumnFormulaEditor.prototype.morphBinsTreatAsExprCheck = function(tBins, bShow, bCheck)
{
   this.binsTreatAsExprCell.style.display = (bShow) ? "" : "none";

   if (null == bCheck)
      bCheck = this.binsTreatAsExprCheck.checked;

   if (!bShow)
      bCheck = false;
   this.binsTreatAsExprCheck.checked = bCheck;

   if (null != tBins)
   {
      var tBinChildren = tBins.selectNodes("saw:bin");
      for (var j=0; j < tBinChildren.length; j++)
      {
         var tb = tBinChildren[j];
         if (null != saw.getLastChildElement(tb) &&
             (XUIGetAttributeBool(tb, "allOther") ||
              saw.getLastChildElement(tb) != saw.getFirstChildElement(tb)))
         {
            var tCurrentExprNode = saw.getLastChildElement(tb);
            if (bCheck)
               XUISetXsiType(tCurrentExprNode, saw.xml.kSawxNamespace, 'sqlExpression');
            else
               XUISetXsiType(tCurrentExprNode, saw.xml.kXsdNamespace, 'string');
         }
      }
   }
}

//-------------------
ColumnFormulaEditor.prototype.resetFilterTableIds = function()
{
   var tCurrentTable = document.getElementById ("idFilterTable");
   if (null != tCurrentTable)
   {
      // reset to its original id
      if (null != tCurrentTable.index)
         tCurrentTable.id = "idFilterTable" + tCurrentTable.index;
      else if (null != tCurrentTable.bForEdit && tCurrentTable.bForEdit)
         tCurrentTable.id = "idFilterTableEdit";
      else
         tCurrentTable.id = "idFilterTableCriteriaPane";
   }
}

//-------------------
ColumnFormulaEditor.prototype.onChildApply = function(sourceEditor)
{
   if (sourceEditor == this.webExpressionSelector)
   {
      // server determined?
      //NQWSetSelectValue (this.form.aggRule, "server");

      // webExpr, webExprDefaultValue and webExprUseQuote should have been set
      // by the child WebExpressionSelector editor
      if (null != this.webExpr &&
          null != this.webExprDefaultValue &&
          null != this.webExprUseQuotes)
      {
         var sQuote = (this.webExprUseQuotes == true) ? "'" : "";

         var sText = sQuote + "@{" + this.webExpr + "}{" + this.webExprDefaultValue + "}" + sQuote;
         this.insertText (sText);

         this.webExpr = null;
         this.webExprDefaultValue = null;
         this.webExprUseQuotes = null;
      }
   }
   else if (sourceEditor == this.columnFormulaBinFilterEditor)
   {
      // fetch the mini-report node and the expr within
      var sMiniReportXPath = "saw:report[@index='" + this.columnFormulaBinFilterEditor.reportIndex + "']";
      var tMiniReportNode = this.tBinWorkSpace.selectSingleNode(sMiniReportXPath);

      if (null != tMiniReportNode)
      {
         var tExpr = tMiniReportNode.selectSingleNode("saw:criteria/saw:filter/sawx:expr");
         if (null != tExpr)
         {
            var bNewBin = false;

            var tBin = this.getBinFromIndex(this.columnFormulaBinFilterEditor.reportIndex);
            var tCurrentExpr = tBin.selectSingleNode("sawx:expr");
            // delete the current bin definition expr and not the bin name expr
            if (null != tCurrentExpr && !(XUIGetXsiType(tCurrentExpr) == 'string' ||
                                          XUIGetXsiType(tCurrentExpr) == 'sqlExpression'))
               tBin.removeChild(tCurrentExpr);
            else
               bNewBin = true;

            if (bNewBin)
               tBin.appendChild(tExpr.cloneNode(true));
            else
               tBin.insertBefore(tExpr.cloneNode(true), tBin.firstChild);

            // redraw the bins
            this.displayBins(!bNewBin);

            // if a new bin was just created, edit its caption
            if (bNewBin)
               // launch the caption popup
               ColumnFormulaEditor.onEditBinCaption(null, this.myId, this.columnFormulaBinFilterEditor.reportIndex, true);
         }
      }

      this.columnFormulaBinFilterEditor = null;
   }
   else if (sourceEditor == this.functionSelector)
   {
      this.functionSelector = null;

      ColumnFormulaEditor.restoreTextSelection(this.eid);

      this.insertText(sourceEditor.selectedExpr, true);
   }   
   else if (sourceEditor == this.variableSelector)
   {
      this.variableSelector = null;

      if (sourceEditor.variableName == null || sourceEditor.variableName.length == 0)
         return;

      var sToReplace = /varname/;

      if (sourceEditor.variableType == "session")
      {
         var sVariableTemplate = "VALUEOF(NQ_SESSION.varname)";
         var sText = sourceEditor.variableName;
         if (sText.indexOf(" ") != -1)
            sText = this.quoteText(sText);
         	
         this.insertText(sVariableTemplate.replace(sToReplace, sText));
      }
      else if (sourceEditor.variableType == "repository")
      {
         var sVariableTemplate = "VALUEOF(varname)";
         var sText = sourceEditor.variableName;
         if (sText.indexOf(".") != -1)
         {
            var sTextArray = sText.split(".");
            sText = this.quoteText(sTextArray[0]) + '.' + this.quoteText(sTextArray[1]);
         }
         else
         {
            sText = this.quoteText(sText);
         }
         this.insertText(sVariableTemplate.replace(sToReplace, sText));
      }
      else if (sourceEditor.variableType == "web")
      {
         var sText = "@{" + sourceEditor.variableName + "}";
         if (sourceEditor.variableDefault != null && sourceEditor.variableDefault.length > 0)
            sText = sText + "{" + sourceEditor.variableDefault + "}";
         	
         this.insertText(sText);
      }
   }   
   else if (sourceEditor == this.complexFilterEditor)
   {
      this.complexFilterEditor = null;

      var filterNode = sourceEditor.newFilterElement;
      if (filterNode != null)
         this.getAdvancedSQL(filterNode);
   }
   else if (sourceEditor == this.columnFormulaBinCaptionEditor)
   {
      // redraw the bins
      this.displayBins();
      this.columnFormulaBinCaptionEditor = null;
   }
   else if (sourceEditor == this.restoreFormulaConfirmDlg)
   {
      // do the actual delete if from delete all
      if (this.restoreFormulaConfirmDlg.bFromDeleteAll)
         this.doDeleteAllBins();

      this.restoreFormulaConfirmDlg = null;

      // keep the case statement and go to the first tab
      XUIPropertyPagesControl.onActivateTab (this.myId + 'Props', 'tab1');
   }
}

//-------------------
ColumnFormulaEditor.prototype.quoteText = function(sText)
{
   if (sText.indexOf("\"") != 0)
      sText = "\"" + sText;
   if (sText.lastIndexOf("\"") != sText.length - 1)
      sText = sText + "\"";
   return sText;
}

//-------------------
ColumnFormulaEditor.prototype.onDisplay = function()
{
   this.propertyPages.init();

   var bBins = (null != this.element.selectSingleNode("saw:bins/saw:bin"));

   // Always activate the first tab upon opening the popup UNLESS there are bins
   XUIPropertyPagesControl.onActivateTab (this.myId + 'Props', bBins? 'tab2' : 'tab1');
}

//-------------------
ColumnFormulaEditor.prototype.addBinFromColumn = function(event, sColumnID)
{
   var sFormula = XUIGetAttributeString(this.element, "formula");
   var tColumnInfo = XUIColumnSpace.findInfo(this.element.getAttribute("columnID"));
   if (null != tColumnInfo)
   {
      // if columnExpr's present, that represents the 'raw' formula (before variables are evaluated)
      var sColumnExprFromColInfo = XUIGetAttributeString(tColumnInfo, "columnExpr");
      var sFormulaFromColInfo = XUIGetAttributeString(tColumnInfo, "formula");
      if (XUIColumn.hasWebVariableExpressions(sColumnExprFromColInfo))
         sFormula = sColumnExprFromColInfo;
      else
         sFormula = sFormulaFromColInfo;
   }

   // filter columns have no column id - try to get columninfo using formula
   if (null == tColumnInfo && sFormula != "")
      tColumnInfo = XUIColumnSpace.findInfo(null, sFormula);
   var sColumnCategory = (null != tColumnInfo) ? XUIColumnSpace.getInfoSQLAttr(tColumnInfo, "category") : "unknown";
   var sColumnPrimaryType = (null != tColumnInfo) ? XUIColumnSpace.getInfoSQLAttr(tColumnInfo, "primaryType") : "unknown";
   var bIsTextColumn = (sColumnCategory == 'text') || (sColumnPrimaryType == 'text');

   /* -- commented out since we are going to allow binning based on the current column alone --
   // if the ColumnFormulaBinFilterEditor dialog is visible, add to the bin being edited currently
   if ((document.getElementById('idFormulaBinFilterDiv') != null) &&
       XUIDialog.isVisible('idFormulaBinFilter'))
   {
      // do this only when the column filter editor is not open
      if ((document.getElementById('idColumnFilterDiv') == null) ||
          !XUIDialog.isVisible('idColumnFilter'))
      {
         var tFormulaBinFilterEditor = XUIPanel.getEditor('idFormulaBinFilter');
         if (null != tFormulaBinFilterEditor)
            tFormulaBinFilterEditor.addFilterFromFormula(sFormula, false);
      }
   }
   else
   ------ */
   {
      var tExprCloneForAgg = null;

      // create a new bin at the end (or just before the "All Other Values" bin if it exists)
      var tBins = XUIForceSingleNode(this.element, saw.xml.kSawNamespace, "bins");

      // if a non-text column, create the "All Other Values" bin (without redisplaying the bins)
      var tNewAllOtherBin = null;
      if (!bIsTextColumn)
         tNewAllOtherBin = ColumnFormulaEditor.onCheckCreateAllOtherValueBin(event, this.myId, true);

      var tBin = null;
      var nIndex = -1;
      if (tBins.childNodes.length > 0)
      {
         var tFirstBin = tBins.childNodes[0];
         var tLastBin = tBins.childNodes[tBins.childNodes.length - 1];

         // is the last bin the "All Other Values" one?
         var bAllOtherPresent = XUIGetAttributeBool(tLastBin, "allOther");

         if (bAllOtherPresent)
         {
            // if there's a bin other than the All Other, retrieve the formula
            if (tFirstBin != tLastBin)
               sFormula = XUIGetAttributeString(tFirstBin, "formula");

            // get the agg type
            var sAggType = "unknown";
            {
               var tUpdColInfo = XUIColumnSpace.findInfo(null, sFormula);
               sAggType = (tUpdColInfo != null) ? XUIColumnSpace.getInfoSQLAttr(tUpdColInfo, "aggType") : "unknown";
            }

            if (sAggType == "agg" && tBins.childNodes.length > 1)
            {
               // if there's a bin before the all other and we are working with an agg type,
               // obtain the expression from the current penultimate bin
               var tAggExpr = tLastBin.previousSibling.selectSingleNode("sawx:expr");
               if (null != tAggExpr)
                  tExprCloneForAgg = tAggExpr.cloneNode(true);
            }

            // insert before the "All Other Values" bin
            tBin = XUIInsertNewElement(tBins, saw.xml.kSawNamespace, "bin", tBins.childNodes.length - 1);

            nIndex = tBins.childNodes.length - 2;
         }
         else
         {
            // retrieve the formula
            sFormula = XUIGetAttributeString(tFirstBin, "formula");

            // get the agg type
            var sAggType = "unknown";
            {
               var tUpdColInfo = XUIColumnSpace.findInfo(null, sFormula);
               sAggType = (tUpdColInfo != null) ? XUIColumnSpace.getInfoSQLAttr(tUpdColInfo, "aggType") : "unknown";
            }

            if (sAggType == "agg")
            {
               // if we are working with an agg type,
               // obtain the expression from the current last bin
               var tAggExpr = tLastBin.selectSingleNode("sawx:expr");
               if (null != tAggExpr)
                  tExprCloneForAgg = tAggExpr.cloneNode(true);
            }

            // append the new bin at the end
            tBin = XUIAppendNewElement(tBins, saw.xml.kSawNamespace, "bin");

            nIndex = tBins.childNodes.length - 1;
         }
      }
      else
      {
         // append the solitary new bin
         tBin = XUIAppendNewElement(tBins, saw.xml.kSawNamespace, "bin");
         nIndex = tBins.childNodes.length - 1;
      }

      if (null != tBin && nIndex >= 0)
      {
         // set the formula for the All Other Values bin created earlier
         if (null != tNewAllOtherBin)
            XUISetAttributeString(tNewAllOtherBin, "formula", sFormula);

         // set the formula attribute on the new bin
         XUISetAttributeString(tBin, "formula", sFormula);

         // display bins (without having to retrieve the case statement from the server)
         this.displayBins(false);

         // make the container div scroll to the bottom
         this.binScrollDiv.scrollTop = this.binScrollDiv.clientHeight;

         // edit this newly-created bin
         ColumnFormulaEditor.onEditBinFilter(null, this.myId, nIndex);

         // show the Column Filter Editor
         var tFormulaBinFilterEditor = XUIPanel.getEditor('idFormulaBinFilter');
         if (null != tFormulaBinFilterEditor)
            tFormulaBinFilterEditor.addFilterFromFormula(sFormula, true, tExprCloneForAgg);
      }
   }
}

//-------------------
ColumnFormulaEditor.prototype.displayBins = function(bGetFormula)
{
   var sCurrentBinFormula = '';

   if (null == bGetFormula)
      bGetFormula = true;

   // reset filter table ids
   this.resetFilterTableIds();

   this.clearHTMLTable();

   // remove all the mini-report XML nodes
   {
      var tMiniReportNode = null;
      while (tMiniReportNode = this.tBinWorkSpace.firstChild)
         this.tBinWorkSpace.removeChild(tMiniReportNode);
   }

   // hide the note at the bottom of the formula text area
   this.showBinNote(false);

   var bIsTextColumn = false;

   // make the formula text area in the first tab editable by default
   this.form.formula.readOnly = false;
   this.form.formula.className = "ColumnFormulaTextArea";
   document.getElementById("FormulaLabelID").className = "XUIPromptCaption";

   var bBinsPresent = false;
   var tBins = this.element.selectSingleNode("saw:bins");

   if (null != tBins)
   {
      var tBinChildren = tBins.selectNodes("saw:bin");

      var i = 0;
      if (tBinChildren.length > 0)
      {
         this.htmlTable.style.display = "";

         bBinsPresent = true;

         // enable custom headings if they are not already
         if (!this.form.customHdg.checked)
         {
            this.form.customHdg.checked = true;
            ColumnFormulaEditor.onClickCustom(this.myId);
         }

         // since there are bins, disable edits in the formula text area
         this.form.formula.readOnly = true;
         this.form.formula.className = "ColumnFormulaDisabledTextArea";
         document.getElementById("FormulaLabelID").className = "XUIPromptDisabledCaption";

         var bIsExpr = this.binsTreatAsExprCheck.checked;
         for (var j=0; j < tBinChildren.length; j++)
         {
            tb = tBinChildren[j];

            if (sCurrentBinFormula == '')
            {
               sCurrentBinFormula = XUIGetAttributeString(tb, "formula");

               // figure out if this was originally a text column or otherwise
               {
                  var tColumnInfo = XUIColumnSpace.findInfo(null, sCurrentBinFormula);
                  var sColumnCategory = (null != tColumnInfo) ? XUIColumnSpace.getInfoSQLAttr (tColumnInfo, "category") : "unknown";
                  var sColumnPrimaryType = (null != tColumnInfo) ? XUIColumnSpace.getInfoSQLAttr (tColumnInfo, "primaryType") : "unknown";
                  bIsTextColumn = (sColumnCategory == 'text') || (sColumnPrimaryType == 'text');
               }
            }

            var tr = this.htmlTable.insertRow(this.htmlTable.rows.length);

            var tCell = tr.insertCell(tr.cells.length);
            tCell.className = "ColumnFormulaBinNumberCell";
            tCell.innerHTML = (i+1) + ".";

            var tExpr = tb.selectSingleNode("sawx:expr");

            ColumnFormulaEditor.addCellsForBin(this.myId, tb, tr, i, tBinChildren.length, tExpr, bIsTextColumn);

            if (null != saw.getLastChildElement(tb) &&
                (XUIGetAttributeBool(tb, "allOther") ||
                saw.getLastChildElement(tb) != saw.getFirstChildElement(tb)))
                bIsExpr = (XUIGetXsiType(saw.getLastChildElement(tb)) == 'sqlExpression');

            i++;
         }

         // if the last bin is not the "All Other Values" one, render a checkbox for the user to create one
         var tLastBin = tBins.childNodes[tBins.childNodes.length - 1];
         if (null != tLastBin &&
             !XUIGetAttributeBool(tLastBin, "allOther"))
         {
            var tr = this.htmlTable.insertRow(this.htmlTable.rows.length);

            var tCell = tr.insertCell(tr.cells.length);
            tCell.className = "ColumnFormulaBinCell";
            //tCell.noWrap = true;

            var tCheckBox = saw.createInput("", null, "checkbox");
            tCheckBox.setAttribute("eid", this.myId);
            saw.addEventListener(tCheckBox, "click", ColumnFormulaEditor.onCheckCreateAllOtherValueBin);
            tCheckBox.binFormula = sCurrentBinFormula;

            var tTextNode = document.createTextNode(kmsgColumnFormulaBinCreateAllOtherValuesBin);

            var tSpan = document.createElement("span");
            tSpan.className='ColumnFormulaBinSpan';

            tSpan.appendChild(tCheckBox);
            tSpan.appendChild(tTextNode);

            tCell.appendChild(tSpan);
            tCell.colSpan = 4;
         }

         this.links.style.display = '';

         // show the note at the bottom of the formula text area
         this.showBinNote(true);

         this.morphBinsTreatAsExprCheck(tBins, true, bIsExpr);
      }
      else
      {
         this.links.style.display = 'none';
         this.morphBinsTreatAsExprCheck(null, false);
      }
   }
   else
   {
      this.links.style.display = 'none';
      this.morphBinsTreatAsExprCheck(null, false);
   }

   if (bGetFormula && bBinsPresent)
   {
      while ((this.form.formula.value.length > 0) && (this.form.formula.value.indexOf(' ') == 0))
         this.form.formula.value = this.form.formula.value.substr(1, this.form.formula.value.length);

      while ((this.form.formula.value.length > 0) && (this.form.formula.value.lastIndexOf(' ') == this.form.formula.value.length-1))
         this.form.formula.value = this.form.formula.value.substr(0, this.form.formula.value.length-1);

      if (this.form.formula.value != "")
      {
         // used for validation (creates a new report with just the necessary criteria)
         var tReport = XUICreateElement(saw.xml.kSawNamespace, 'report');
         tReport.setAttribute('xmlns:xsi', 'http://www.w3.org/2001/XMLSchema-instance');
         tReport.setAttribute('xmlns:sawx','com.siebel.analytics.web/expression/v1');

         tReport.appendChild(this.criteriaElement.cloneNode(true));

         this.form.ReportXML.value = saw.getXmlText(tReport);

         // make a server call to get the CASE statement        
         var req = new sawr.serverRequest("GetColumnInfoXML", ColumnFormulaEditor.loadBinFormula);
 	      req.setFatalErrorHandler(ColumnFormulaEditor.handleServerError);
         req.setCallerObj(this);
         req.setContextInfo(["GetBinFormula"]);
         var conn = new sawr.xhrConnection(req);

         conn.postForm(this.form);
      }
   }
}

ColumnFormulaEditor.loadBinFormula = function(tData)
{
   var tEditor = tData.getCallerObj();
   
   ColumnFormulaEditor.loadColumnInfo(tData);
   
   var tColumnInfo = XUIColumnSpace.findInfo(tEditor.element.getAttribute("columnID"));

   if (null != tColumnInfo)
   {
      // update the formula text area with the CASE statement
      var sColumnExpr = XUIGetAttributeString(tColumnInfo, "columnExpr");
      tEditor.form.formula.value = 
         XUIColumn.hasWebVariableExpressions(sColumnExpr) ? sColumnExpr : 
            XUIGetAttributeString(tColumnInfo, "formula");
   }

   if (null != tEditor.filterExprElement)
   {
      //set this to null cos next when we add the name for the bin
      // the formula gets updated and we only need to replace the colinfo
      //see code above for that
      tEditor.filterExprElement = null;
   }
}

//-------------------
ColumnFormulaEditor.prototype.clearHTMLTable = function()
{
   while (this.htmlTable.rows.length > 0)
      this.htmlTable.deleteRow(-1);

   this.htmlTable.style.display = "none";
}

//-------------------
ColumnFormulaEditor.prototype.getBinFromIndex = function(nIndex)
{
   var tBin = null;
   var tBins = this.element.selectSingleNode("saw:bins");

   if (null != tBins)
   {
      var tBinChildren = tBins.selectNodes("saw:bin");

      var i = 0;
      if (tBinChildren.length > 0)
      {
         for (var j=0; j < tBinChildren.length; j++)
         {
            tb = tBinChildren[j];
            if (i == nIndex)
            {
               tBin = tb;
               break;
            }

            i++;
         }
      }
   }

   return tBin;
}

////////////////////////////////////////////////////////////////////////////////////////////
// Events
////////////////////////////////////////////////////////////////////////////////////////////

ColumnFormulaEditor.onClickCustom = function(eid)
{
   var tPanel = XUIPanel.getPanel(eid);
   var tEditor = XUIPanel.getEditor(eid);

   var tCtl = tEditor.form.customHdg;
   if (tCtl.checked)
   {
      //tEditor.form.tableHdg.value = XUIColumn.getTableHeadingFromFormula(tEditor.form.formula.value);
      //tEditor.form.columnHdg.value = XUIColumn.getColumnHeadingFromFormula(tEditor.form.formula.value);

      document.getElementById("FormulaTableHdgID").className = "XUIPromptCaption";
      document.getElementById("FormulaColumnHdgID").className = "XUIPromptCaption";
      tEditor.form.tableHdg.disabled = false;
      tEditor.form.columnHdg.disabled = false;
   }
   else
   {
      tEditor.displayDefaultHeadings();

      document.getElementById("FormulaTableHdgID").className = "XUIPromptDisabledCaption";
      document.getElementById("FormulaColumnHdgID").className = "XUIPromptDisabledCaption";
      tEditor.form.tableHdg.disabled = true;
      tEditor.form.columnHdg.disabled = true;
   }
   return true;
}

//-------------------
ColumnFormulaEditor.onClickIgnore = function(eid)
{
   var tEditor = XUIPanel.getEditor(eid);

   if (tEditor.errorCell.sCallerContext == "ReflectNewFormula")
   {
      // update the column space with the 'incorrect' formula
      var tColumnInfo = XUIColumnSpace.findInfo(tEditor.sColumnID);

      if (null != tColumnInfo)
      {
         // update the column space with the formula
         XUISetAttributeString(tColumnInfo, "formula", tEditor.form.formula.value);

         // update the display formula as well
         var tsi = tColumnInfo.selectSingleNode("saw:SQLInfo");
         if (null != tsi)
            XUISetAttributeString(tsi, "displayFormula", escapequotes(tEditor.form.formula.value));
      }
   }

   tEditor.update(tEditor.errorCell.sCallerContext);

   // activate the bins tab again once the user chooses to ignore the error
   if (tEditor.errorCell.sCallerContext == "GetBinFormula")
   {
      XUIPropertyPagesControl.onActivateTab (tEditor.myId + 'Props', 'tab2');
      tEditor.displayBins(false);
   }
}

//-------------------
ColumnFormulaEditor.openWebExpressionSelector = function(event, eid)
{
   var tEditor = XUIPanel.getEditor(eid);
   var tDialog = new XUIDialog('idWebExprSelector', tEditor.webExpressionSelector, tEditor);

   tDialog.show (tEditor.element, event.clientX-150, event.clientY);
}

//-------------------
ColumnFormulaEditor.onCheckCreateAllOtherValueBin = function(event, eid, bAddOnly)
{
   if (null == eid && null != event)
      eid = saw.getEventTarget(event).getAttribute("eid");

   var tEditor = XUIPanel.getEditor(eid);

   if (null == bAddOnly)
      bAddOnly = false;

   var tBins = tEditor.element.selectSingleNode("saw:bins");
   if (null != tBins)
   {
      // ensure that the All Other bin is not present already
      if (tBins.childNodes.length > 0)
      {
         var tLastBin = tBins.childNodes[tBins.childNodes.length - 1];

         // is the last bin the "All Other Values" one?
         var bAllOtherPresent = XUIGetAttributeBool(tLastBin, "allOther");

         if (bAllOtherPresent)
            return tLastBin;
      }

      var tBin = XUIAppendNewElement(tBins, saw.xml.kSawNamespace, "bin");
      XUISetAttributeBool(tBin, "allOther", true);

      if (!bAddOnly)
      {
         if (null != event &&
             null != saw.getEventTarget(event) &&
             null != saw.getEventTarget(event).binFormula)
            XUISetAttributeString(tBin, "formula", saw.getEventTarget(event).binFormula);

         tEditor.displayBins(false);

         // launch the caption popup
         ColumnFormulaEditor.onEditBinCaption(null, eid, tBins.childNodes.length - 1, true);
      }

      return tBin;
   }

   return null;
}

//-------------------
ColumnFormulaEditor.onClickBinsTreatAsExpr = function(eid, event)
{
   var tEditor = XUIPanel.getEditor(eid);

   var tBins = tEditor.element.selectSingleNode("saw:bins");
   if (null != tBins)
   {
      tEditor.morphBinsTreatAsExprCheck(tBins, true, saw.getEventTarget(event).checked);
      // fetch the updated case statement
      tEditor.displayBins();
   }
}

//-------------------
ColumnFormulaEditor.onRemoveBins = function(event, eid)
{
   var tEditor = XUIPanel.getEditor(eid);

   tEditor.deleteAllBins(event);
}

//-------------------
ColumnFormulaEditor.onUp = function(event, eid, nIndex)
{
   if (null == eid && null != event)
      eid = saw.getEventTarget(event).getAttribute("eid");
   if (null == nIndex && null != event)
      nIndex = saw.getEventTarget(event).getAttribute("nIndex");

   var tEditor = XUIPanel.getEditor(eid);

   tEditor.moveUp(nIndex);
}

//-------------------
ColumnFormulaEditor.onDown = function(event, eid, nIndex)
{
   if (null == eid && null != event)
      eid = saw.getEventTarget(event).getAttribute("eid");
   if (null == nIndex && null != event)
      nIndex = saw.getEventTarget(event).getAttribute("nIndex");

   var tEditor = XUIPanel.getEditor(eid);

   tEditor.moveDown(nIndex);
}

//-------------------
ColumnFormulaEditor.onDelete = function(event, eid, nIndex)
{
   if (null == eid && null != event)
      eid = saw.getEventTarget(event).getAttribute("eid");
   if (null == nIndex && null != event)
      nIndex = saw.getEventTarget(event).getAttribute("nIndex");

   var tEditor = XUIPanel.getEditor(eid);

   tEditor.deleteBin(event, nIndex);
}

//-------------------
// NOT USED ANYMORE (since we are now binning on the current column alone)
//ColumnFormulaEditor.initializeBinColumnMenu = function(event, tMenu)
//{
// var tEditor = XUIPanel.getEditor('idFormula');
//
//   tMenu.innerHTML = "";
//
//   var tColumns = tEditor.criteriaElement.selectSingleNode("saw:columns");
//   if (tColumns != null)
//   {
//      var tCol = tColumns.firstChild;
//      while (tCol != null)
//    {
//       var sNewAnchor = '<a href="javascript:void(null)" class="NQWMenuItem" onclick="ColumnFormulaEditor.onAddBin(event, \'idFormula\',\'' + XUIGetAttributeString(tCol, "columnID") + '\'); return false;">';
//       var sCaption = XUIColumnSpace.getHeadingFromColumn(tCol, "saw:columnHeading");
//       sNewAnchor/*innerText*/ += (sCaption.length > 45) ? sCaption.substr(0, 40) + "..." : sCaption;
//         sNewAnchor += "</a>";
//       tMenu.innerHTML += sNewAnchor;
//
//       tCol = tCol.nextSibling;
//    }
// }
//}

ColumnFormulaEditor.initializeInsertColumnMenu = function(event, tMenu)
{
  var tEditor = XUIPanel.getEditor('idFormula');

  var tMenuHTML = "";

  var tColumns = tEditor.criteriaElement.selectSingleNode("saw:columns");
  if (tColumns != null)
  {
    var tCol = tColumns.firstChild;
    while (tCol != null)
    {
      if (tCol.nodeType != 3/*TEXT_NODE*/)
      {
        if (XUIGetAttributeString(tCol, "columnID") != XUIGetAttributeString(tEditor.originalElement, "columnID"))
        {
           var sNewAnchor = '<a href="javascript:void(null)" class="NQWMenuItem" onclick="ColumnFormulaEditor.onInsertColumn(event, \'idFormula\', \'' + XUIGetAttributeString(tCol, "columnID") + '\'); return false;">';
           var sCaption = XUIColumnSpace.getHeadingFromColumn(tCol, "saw:columnHeading");
           sNewAnchor += (sCaption.length > 45) ? sCaption.substr(0, 40) + "..." : sCaption;
               sNewAnchor += "</a>";
           tMenuHTML += sNewAnchor;
        }
      }
      tCol = tCol.nextSibling;
    }
  }
  if (tMenuHTML == "")
      tMenuHTML = '<a  href="javascript:void(null)" class="NQWMenuItem" onclick="NQWClearActiveMenu(); return false;">' + kuiColumnFormulaEditorNone + '</a>'; 
	
  saw.getMenuItemContainer(tMenu).innerHTML = tMenuHTML;
}


ColumnFormulaEditor.onInsertFilter = function(event, eid)
{
   var tEditor = XUIPanel.getEditor(eid);

   ColumnFormulaEditor.saveTextSelection(tEditor.eid);

   var tTextArea = tEditor.form.formula;
   var sSelectedText = "";
   if (is_ie == true)
   {
      if (tEditor.savedSelection != null)
      {
         sSelectedText = tEditor.savedSelection.text;
      }
      else 
      {
        tTextArea.focus();                               //put focus on the textarea
        if (this.savedCaretPos != null)
           sSelectedText = this.savedCaretPos.text;
      }
   }
   else 
   {
      var tTR = document.createRange();
      tTR.selectNodeContents(tTextArea);

      if (tTextArea.selectionStart != -1 && tTextArea.selectionEnd != -1)       //if focused
      {
         var start = tTextArea.selectionStart;
         var end = tTextArea.selectionEnd;
         sSelectedText = tTextArea.value.substr(start, end - start);
      }
      else 
      {
         tTextArea.focus();                               //put focus on the textarea
         if (this.savedCaretPos != null)
            sSelectedText = this.savedCaretPos.text;
      }
   }
   if (sSelectedText != null && sSelectedText.length > 0)
   {
      var tColumnInfo = XUIColumnSpace.findInfo(null, sSelectedText);
      var sColumnCategory = (null != tColumnInfo) ? XUIColumnSpace.getInfoSQLAttr (tColumnInfo, "category") : "unknown";
      var sColumnPrimaryType = (null != tColumnInfo) ? XUIColumnSpace.getInfoSQLAttr (tColumnInfo, "primaryType") : "unknown";
      var bIsTextColumn = (sColumnCategory == 'text') || (sColumnPrimaryType == 'text');
      if (bIsTextColumn)
      {
         alert(kmsgEditFormulaFilterMeasureRequired);
         ColumnFormulaEditor.restoreTextSelection(tEditor.eid);
         tEditor.focus();
         return;
      }
   }
   var tComplexFilterEditor = new ComplexFilterEditor('idComplexFilter', sSelectedText);
   var tDialog = new XUIDialog('idComplexFilter', tComplexFilterEditor, tEditor);

   tEditor.complexFilterEditor = tComplexFilterEditor;

   var tReport = XUICreateElement(saw.xml.kSawNamespace, 'report');
   tReport.setAttribute('xmlns:xsi', 'http://www.w3.org/2001/XMLSchema-instance');
   tReport.setAttribute('xmlns:sawx','com.siebel.analytics.web/expression/v1');
   tReport.appendChild(tEditor.criteriaElement.cloneNode(true));

   if (event != null)
      tDialog.show(tEditor.criteriaElement, event.clientX - 200, event.clientY - 150, tReport);
   else
      tDialog.show(tEditor.criteriaElement, 100, 100, tReport);

   tComplexFilterEditor.filterPanel.editor.displayFilter();
}

ColumnFormulaEditor.onInsertColumn = function(event, eid, sColumnID)
{
   var tEditor = XUIPanel.getEditor(eid);

   var tColumnInfo = XUIColumnSpace.findInfo(sColumnID);
   var sFormula = XUIGetAttributeString(tColumnInfo, "formula");

   NQWClearActiveMenu();

   tEditor.insertText(sFormula);
   tEditor.form.formula.focus();
}

ColumnFormulaEditor.onInsertVariable = function(event, eid, variableType)
{
   var tEditor = XUIPanel.getEditor(eid);

   NQWClearActiveMenu();

   var tVariableSelector = new VariableSelector('idVariableSelector', variableType);
   var tDialog = new XUIDialog('idVariableSelector', tVariableSelector, tEditor);

   tEditor.variableSelector = tVariableSelector;

   if (event != null)
      tDialog.show(tEditor.criteriaElement, event.clientX - 150, event.clientY - 160);
   else
      tDialog.show(tEditor.criteriaElement, 100, 100);
}

ColumnFormulaEditor.onInsertFunction = function(event, eid)
{
   var tEditor = XUIPanel.getEditor(eid);

   ColumnFormulaEditor.saveTextSelection(eid);

   var tFunctionSelector = new FunctionSelector('idFunctionSelector');
   var tDialog = new XUIDialog('idFunctionSelector', tFunctionSelector, tEditor);

   tEditor.functionSelector = tFunctionSelector;

   if (event != null)
      tDialog.show(tEditor.criteriaElement, event.clientX - 100, event.clientY - 250);
   else
      tDialog.show(tEditor.criteriaElement, 100, 100);
}

ColumnFormulaEditor.onInsertOperator = function(event, eid, operator)
{
   var tEditor = XUIPanel.getEditor(eid);

   tEditor.insertText(operator);
   tEditor.form.formula.focus();
}

ColumnFormulaEditor.prototype.getAdvancedSQL = function(filterNode)
{
   this.advancedSQLForm = document.getElementById(this.form.id+'AdvancedSQL');
   this.advancedSQLForm.action = saw.commandToURL('ConvertFilterToSQL');
   this.advancedSQLForm.FilterXML.value = '<nqw>' + filterNode.xml + '</nqw>';
   this.advancedSQLForm.SubjectArea.value = this.criteriaElement.getAttribute('subjectArea')
 	var req = new sawr.serverRequest("ConvertFilterToSQL", ColumnFormulaEditor.loadSQL);
   req.setCallerObj(this);
   var conn = new sawr.xhrConnection(req);
   conn.postForm(this.advancedSQLForm);
}

ColumnFormulaEditor.loadSQL = function(tData)
{
   var tEditor = tData.getCallerObj();
   var sSql = '';

	var s = tData.getXML().selectSingleNode('sawr:sql');

	if(s)
	{
      sSql = XUIGetElementText(s);
      var sFilterTemplate = "FILTER(expr USING (replace))";
      var sToReplace = /replace/;
      ColumnFormulaEditor.restoreTextSelection(tEditor.eid);
      tEditor.insertText(sFilterTemplate.replace(sToReplace, sSql), true);
   }
}

ColumnFormulaEditor.restoreTextSelection = function(eid)
{
   var tEditor = XUIPanel.getEditor(eid);

   if (tEditor.savedSelection != null)
   {
      tEditor.savedSelection.select();
      tEditor.savedSelection = null;
   }
}

ColumnFormulaEditor.saveTextSelection = function(eid)
{
   var tEditor = XUIPanel.getEditor(eid);

   tEditor.savedSelection = null;

   if (is_ie)
   {
      var tTextArea = tEditor.form.formula;
      var tTR = document.body.createTextRange();
      tTR.moveToElementText(tTextArea);
      var   tSel = document.selection.createRange();
      if (tTR.inRange(tSel))       //if focused
      {
         tEditor.savedSelection = tSel.duplicate();
      }
   }
}


//-------------------
ColumnFormulaEditor.prototype.handleCaretStore = function(tTextElement)
{
    ColumnFormulaEditor.storeCaret(tTextElement);
}

ColumnFormulaEditor.storeCaret = function (tTextElement)
{
    if (tTextElement.createTextRange)
    {
        this.savedCaretPos = document.selection.createRange().duplicate();
    }
}

//-------------------
ColumnFormulaEditor.processFormulaKeyEvent = function(event)
{
   var escape = 27;

   // prevent firefox from canceling the server request when user hits ESCAPE
   if (event.keyCode == escape && is_ie == false)
      return false;
   else
      return true;
}

//-------------------
ColumnFormulaEditor.onAddBin = function(event, eid, sColumnID)
{
   var tEditor = XUIPanel.getEditor(eid);

   if (null == sColumnID)
      sColumnID = XUIGetAttributeString(tEditor.element, "columnID");

   tEditor.sColumnID = null;

   if (tEditor.hasBins())
      tEditor.addBinFromColumn(event, sColumnID);
   else
   {
      var sFormula = XUIGetAttributeString(tEditor.element, "formula");
      var tColumnInfo = XUIColumnSpace.findInfo(sColumnID);
      if (null != tColumnInfo)
      {
         var sColumnExprFromColInfo = XUIGetAttributeString(tColumnInfo, "columnExpr");
         var sFormulaFromColInfo = XUIGetAttributeString(tColumnInfo, "formula");
         if (XUIColumn.hasWebVariableExpressions(sColumnExprFromColInfo))
            sFormula = sColumnExprFromColInfo;
         else
            sFormula = sFormulaFromColInfo;
      }

      // if an empty formula, can't do anything
      if (tEditor.form.formula.value == "")
      {
         alert(kmsgColumnFormulaBinsEmptyFormula);
         // go to the first tab
         XUIPropertyPagesControl.onActivateTab (tEditor.myId + 'Props', 'tab1');
         return false;
      }

      // make a server call as necessary, to ensure that any updates
      // to the formula are captured
      if (tEditor.form.formula.value != sFormula)
      {
         tEditor.sColumnID = sColumnID;

         var tReport = XUICreateElement(saw.xml.kSawNamespace, 'report');
         tReport.setAttribute('xmlns:xsi', 'http://www.w3.org/2001/XMLSchema-instance');
         tReport.setAttribute('xmlns:sawx','com.siebel.analytics.web/expression/v1');

         tReport.appendChild(tEditor.criteriaElement.cloneNode(true));

         tEditor.form.ReportXML.value = saw.getXmlText(tReport);
         
         var req = new sawr.serverRequest("GetColumnInfoXML", ColumnFormulaEditor.reflectNewFormula);
 	      req.setFatalErrorHandler(ColumnFormulaEditor.handleServerError);
         req.setCallerObj(tEditor);
         req.setContextInfo(["ReflectNewFormula"]);
         var conn = new sawr.xhrConnection(req);
         conn.postForm(tEditor.form)
         
         tEditor.eventReflectNewFormula = event;
      }
      else
         tEditor.addBinFromColumn(event, sColumnID);
   }

   //NQWClearActiveMenu();
}

ColumnFormulaEditor.reflectNewFormula = function(tData)
{
   ColumnFormulaEditor.loadColumnInfo(tData);
   var tEditor = tData.getCallerObj();
   // ensure that the Bins tab is active
   XUIPropertyPagesControl.onActivateTab (tEditor.myId + 'Props', 'tab2');

   // column space has been udpated (or error ignored); initiate adding a new bin now
   tEditor.addBinFromColumn(tEditor.eventReflectNewFormula, tEditor.sColumnID);
}

//-------------------
ColumnFormulaEditor.onEditBinFilter = function(event, eid, nIndex)
{
   if (null == eid && null != event)
      eid = saw.getEventTarget(event).getAttribute("eid");
   if (null == nIndex && null != event)
      nIndex = saw.getEventTarget(event).getAttribute("nIndex");

   var tEditor = XUIPanel.getEditor(eid);

   // fetch the bin
   var tEditBin = tEditor.getBinFromIndex(nIndex);
   if (null != tEditBin)
   {
      // fetch the criteria and report nodes from the mini-report island
      var tReport = null;
      var tCriteria = null;

      tReport = tEditor.tBinWorkSpace.selectSingleNode("saw:report[@index='" + nIndex + "']");
      if (null != tReport)
         tCriteria = tReport.selectSingleNode("saw:criteria");

      if (null != tCriteria)
      {
         var tBinFilterEditor = new ColumnFormulaBinFilterEditor('idFormulaBinFilter', tEditor.bIsListFormat);
         var tDialog = new XUIDialog('idFormulaBinFilter', tBinFilterEditor, tEditor);
         tEditor.columnFormulaBinFilterEditor = tBinFilterEditor;
         tEditor.columnFormulaBinFilterEditor.reportIndex = nIndex;

         var iLeft = 10 + saw.calcAbsoluteLeft(document.getElementById("BinFilterIcon" + nIndex)) - saw.getDocumentScrollLeft() - tEditor.binScrollDiv.scrollLeft;
         var iTop = 10 + saw.calcAbsoluteTop(document.getElementById("BinFilterIcon" + nIndex)) - saw.getDocumentScrollTop() - tEditor.binScrollDiv.scrollTop;

         tEditor.columnFormulaBinFilterEditor.iLeft = iLeft;
         tEditor.columnFormulaBinFilterEditor.iTop = iTop;

         tDialog.show(tCriteria, iLeft, iTop, tReport);

         // if this is a new bin, hide the intermediate dialog
         //if (null == tCriteria.selectSingleNode("saw:filter/sawx:expr"))

         // hide the dialog all the time since we are binning on the same column
         tDialog.div.style.display = 'none';

         // if an existing bin, edit the bin filter expr
         if (null != tCriteria.selectSingleNode("saw:filter/sawx:expr"))
            tBinFilterEditor.editCurrentFilter();
      }
   }
}

//-------------------
ColumnFormulaEditor.onEditBinCaption = function(event, eid, nIndex, bNewCaption)
{
   if (null == eid && null != event)
      eid = saw.getEventTarget(event).getAttribute("eid");
   if (null == nIndex && null != event)
      nIndex = saw.getEventTarget(event).getAttribute("nIndex");
   if (null == bNewCaption)
      bNewCaption = false;

   var tEditor = XUIPanel.getEditor(eid);

   // fetch the bin
   var tEditBin = tEditor.getBinFromIndex(nIndex);
   if (null != tEditBin)
   {
      var tColumnFormulaBinCaptionEditor = new ColumnFormulaBinCaptionEditor('idEditBinCaption', tEditor.binsTreatAsExprCheck.checked, bNewCaption);
      var tDialog = new XUIDialog('idEditBinCaption', tColumnFormulaBinCaptionEditor, tEditor);
      tEditor.columnFormulaBinCaptionEditor = tColumnFormulaBinCaptionEditor;

      var iLeft = 5 + saw.calcAbsoluteLeft(document.getElementById("BinCaptionIcon" + nIndex)) - saw.getDocumentScrollLeft() - tEditor.binScrollDiv.scrollLeft;
      var iTop = 5 + saw.calcAbsoluteTop(document.getElementById("BinCaptionIcon" + nIndex)) - saw.getDocumentScrollTop() - tEditor.binScrollDiv.scrollTop;

      tDialog.show(tEditBin, iLeft, iTop);
   }

   return false;
}

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////

ColumnFormulaEditor.addCellsForBin = function(eid, tBin, tRow, nIndex, nBins, tExpr, bIsTextColumn)
{
   var tEditor = XUIPanel.getEditor(eid);

   var tCell = tRow.insertCell(tRow.cells.length);
   tCell.className = "ColumnFormulaBinCell";
   	
   if(saw.isRToL())
      tCell.style.textAlign = "right";
   else
      tCell.style.textAlign = "left";

   var tOuterTable = document.createElement('table');
   tOuterTable.cellpadding = "0";
   tOuterTable.cellspacing = "0";
   tOuterTable.border = "0";

   tCell.appendChild(tOuterTable);

   var tOuterRow = tOuterTable.insertRow(tOuterTable.rows.length);
   var tOuterCell1 = tOuterRow.insertCell(tOuterRow.cells.length);

   // is this an "All Other" bin?
   var bAllOther = XUIGetAttributeBool(tBin, "allOther");

   if (!bAllOther)
   {
      // append a table to this cell
      var tFilterTable = document.createElement ("table");
      tFilterTable.index = nIndex;
      tFilterTable.className = "FilterOuterTable";

      // set the id in order to display the filter definition
      tFilterTable.id = "idFilterTable";

      tOuterCell1.appendChild(tFilterTable);

      var tReportChild;
      var tCriteria;
      // insert the mini-report XML node into the bin workspace
      {
         tReportChild = XUIAppendNewElement (tEditor.tBinWorkSpace, saw.xml.kSawNamespace, "report");
         if (null != tReportChild)
         {
            // set an attribute to indicate the corresponding group index
            XUISetAttributeString (tReportChild, "index", ("" + nIndex));

            tCriteria = XUIAppendNewElement (tReportChild, saw.xml.kSawNamespace, "criteria");
            if (null != tCriteria)
            {
               var sSubjectArea = XUIGetAttributeString(tEditor.criteriaElement, "subjectArea");

               XUISetAttributeString (tCriteria, "subjectArea", sSubjectArea);

               var tColumns = XUIAppendNewElement (tCriteria, saw.xml.kSawNamespace, "columns");
               if (null != tColumns)
               {
                  var tColumn = XUIAppendNewElement (tColumns, saw.xml.kSawNamespace, "column");
                  if (null != tColumn)
                  {
                     // retrieve the formula from the bin
                     XUISetAttributeString (tColumn, "formula", XUIGetAttributeString(tBin, "formula"));
                     //XUISetAttributeString (tColumn, "columnID", XUIGetAttributeString(tEditor.element, "columnID"));
                     
                     // add the display timezone for timeStamp type if it exists
                     var tColumnInfo = XUIColumnSpace.findInfo(null, XUIGetAttributeString(tBin, "formula"));
                     if (tColumnInfo && XUIColumnSpace.getInfoSQLAttr(tColumnInfo, "primaryType") == 'timeStamp')
                     {
                        var tDataFormat = saw.tz.getDataFormatNode(XUIGetAttributeString(tBin, "formula"), tEditor.criteriaElement);
                        if (tDataFormat != null && tDataFormat.getAttribute('displayTimeZone'))
                        {
                           var tDisplayFormat = XUIAppendNewElement (tColumn, saw.xml.kSawNamespace, "displayFormat");
                           var tDF = XUIAppendNewElement (tDisplayFormat, saw.xml.kSawNamespace, "dataFormat");
                           tDF.setAttribute('displayTimeZone', tDataFormat.getAttribute('displayTimeZone'));
                        }
                     }
                  }
               }

               // create the filter predicate from the bin expr
               var tFilter = XUIAppendNewElement (tCriteria, saw.xml.kSawNamespace, "filter");
               XUISetAttributeString (tFilter, "subjectArea", sSubjectArea);
               if (null != tExpr) // not null for existing bins; null for one that's being newly created
                  tFilter.appendChild(tExpr.cloneNode(true));
            }
         }
      }

      // create the filter editor
      var tFilterEditor = new FilterEditor('idFilter');
      // turn off edits in the filter editor
      tFilterEditor.disableFilterEdits = true;

      var tFilterPanel = new XUIInline ('idFilter', tFilterEditor, tEditor);

      // change the links reference
      tFilterEditor.links = document.getElementById("idFormulaBinFilterLinks");

      // load the criteria and report into the filter editor
      tFilterPanel.load (tCriteria, tReportChild);

      tFilterEditor.links.style.display = "none";

      tFilterTable.id = "idFilterTable" + nIndex;

      // append the filter icon to launch the edit dialog
      {
         var tOuterCell2 = tOuterRow.insertCell(tOuterRow.cells.length);
         tOuterCell2.className = "ConditionLinks";
         if(saw.isRToL())
            tOuterCell2.align = "left";
         else
            tOuterCell2.align = "right";

         var ta = document.createElement('a');
         ta.href = "javascript:void(null)";
         ta.id = "BinFilterIcon" + nIndex;
         saw.addEventListener(ta, "click", ColumnFormulaEditor.onEditBinFilter);
         ta.setAttribute("eid", eid);
         ta.setAttribute("nIndex", nIndex);

         var ti = document.createElement('img');
         ti.align = "absMiddle";
         ti.border = "0";
         ti.src = kimgColumnFormulaBinFilter;
         ti.title = kmsgColumnFormulaBinEditFilter;
         ti.setAttribute("eid", eid);
         ti.setAttribute("nIndex", nIndex);
         ta.appendChild (ti);

         tOuterCell2.appendChild(ta);
      }
   }
   else
   {
      var tAllOtherValuesSpan = document.createElement("span");
      tAllOtherValuesSpan.className = 'ColumnFormulaBinSpan';
      var tAllOtherValuesTextNode = document.createTextNode(kmsgColumnFormulaBinAllOtherValues);
      tAllOtherValuesSpan.appendChild(tAllOtherValuesTextNode);
      tOuterCell1.appendChild(tAllOtherValuesSpan);
   }

   //tCell.noWrap = true;

   // display the bin value
   var sDisplayCaption = '';
   if (null != tBin.lastChild &&
       (bAllOther || tBin.lastChild != tBin.firstChild))
      sDisplayCaption = XUIGetElementText(tBin.lastChild);

   tCell = tRow.insertCell(tRow.cells.length);
   tCell.className = "ColumnFormulaBinCell";

   var tOuterCaptionTable = document.createElement('table');
   tOuterCaptionTable.cellpadding = "4";
   tOuterCaptionTable.cellspacing = "0";
   tOuterCaptionTable.border = "0";

   tCell.appendChild(tOuterCaptionTable);

   var tOuterCaptionRow = tOuterCaptionTable.insertRow(tOuterCaptionTable.rows.length);
   var tOuterCaptionCell1 = tOuterCaptionRow.insertCell(tOuterCaptionRow.cells.length);

   var tDisplayCaptionSpan = document.createElement("span");
   tDisplayCaptionSpan.className = 'ColumnFormulaBinCaptionSpan';
   var tDisplayTextNode = document.createTextNode(sDisplayCaption);
   tDisplayCaptionSpan.appendChild(tDisplayTextNode);

   tOuterCaptionCell1.appendChild(tDisplayCaptionSpan);

   // append the props icon to launch the edit dialog for the value
   {
      var tOuterCaptionCell2 = tOuterCaptionRow.insertCell(tOuterCaptionRow.cells.length);
      tOuterCaptionCell2.className = "ConditionLinks";
      if(saw.isRToL())
         tOuterCaptionCell2.align = "left";
      else
         tOuterCaptionCell2.align = "right";

      var ta = document.createElement('a');
      ta.href = "javascript:void(null)";
      ta.id = "BinCaptionIcon" + nIndex;
      saw.addEventListener(ta, "click", ColumnFormulaEditor.onEditBinCaption);
      ta.setAttribute("eid", eid);
      ta.setAttribute("nIndex", nIndex);

      var ti = document.createElement('img');
      ti.align = "absMiddle";
      ti.border = "0";
      ti.src = kimgColumnFormulaBinProps;
      ti.title = kmsgColumnFormulaBinEditValue;
      ti.setAttribute("eid", eid);
      ti.setAttribute("nIndex", nIndex);
      ta.appendChild (ti);

      tOuterCaptionCell2.appendChild(ta);
   }

   //tCell.noWrap = true;

   // append the cell with the move up/down and delete icons
   var tc3 = tRow.insertCell(tRow.cells.length);
   tc3.className = "ConditionLinks";

   // show the delete icon
   {
      // Delete
      var ta5 = document.createElement('a');
      ta5.href = "javascript:void(null)";
      saw.addEventListener(ta5, "click", ColumnFormulaEditor.onDelete);
      ta5.setAttribute("eid", eid);
      ta5.setAttribute("nIndex", nIndex);

      var ti5 = document.createElement('img');
      ti5.border = "0";
      ti5.src = kimgColumnFormulaBinDelete;
      ti5.title = kmsgFilterSysDelete;
      ti5.setAttribute("eid", eid);
      ti5.setAttribute("nIndex", nIndex);
      ta5.appendChild(ti5);

      tc3.appendChild(ta5);
      tc3.appendChild(document.createTextNode(" "));
   }

   // Down
   // not 'all other' and not the last one
   if (!bAllOther && null != tBin.nextSibling)
   {
      // not the one above 'all other' either
      if (!XUIGetAttributeBool(tBin.nextSibling, "allOther"))
      {
         var ta4 = document.createElement('a');
         ta4.href = "javascript:void(null)";
         saw.addEventListener(ta4, "click", ColumnFormulaEditor.onDown);
         ta4.setAttribute("eid", eid);
         ta4.setAttribute("nIndex", nIndex);

         var ti4 = document.createElement('img');
         ti4.border = "0";
         ti4.src = kimgColumnFormulaBinDown;
         ti4.title = kmsgColumnFormulaBinMoveDown;
         ti4.setAttribute("eid", eid);
         ti4.setAttribute("nIndex", nIndex);
         ta4.appendChild(ti4);

         tc3.appendChild(ta4);
         tc3.appendChild(document.createTextNode(" "));
      }
   }

   // Up
   // not 'all other' and not the first row
   if (!bAllOther && nIndex > 0)
   {
      var ta3 = document.createElement('a');
      ta3.href = "javascript:void(null)";
      saw.addEventListener(ta3, "click", ColumnFormulaEditor.onUp);
      ta3.setAttribute("eid", eid);
      ta3.setAttribute("nIndex", nIndex);

      var ti3 = document.createElement('img');
      ti3.border = "0";
      ti3.src = kimgColumnFormulaBinUp;
      ti3.title = kmsgColumnFormulaBinMoveUp;
      ti3.setAttribute("eid", eid);
      ti3.setAttribute("nIndex", nIndex);
      ta3.appendChild(ti3);

      tc3.appendChild(ta3);
      tc3.appendChild(document.createTextNode(" "));
   }

   tc3.noWrap = true;
}

